/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: hello.c,v 1.40 2005/06/29 00:23:16 eugene Exp $";

/*
 * MX version of "Hello, world."
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "mx_auto_config.h"
#include "myriexpress.h"

#define HELLO_FILTER 0xabcd1234

#define MAKE_MATCH(a,b) ((uint64_t)(a) << 32 | (b))

int
main(int argc,
     char **argv)
{
  int c;
  int sender;
  extern char *optarg;
  mx_return_t rc;

  mx_endpoint_t my_endpoint;
  mx_endpoint_addr_t my_address;
  uint64_t my_nic_id;
  uint32_t my_endpoint_id;
  uint32_t filter_value;

  uint32_t remote_endpoint_id;
  uint64_t remote_nic_id;
  char *remote_hostname;
  mx_endpoint_addr_t dest;

  char buf[80];
  mx_segment_t seg[2];
  mx_request_t handle;
  mx_status_t stat;
  uint32_t unmaskable;
  uint32_t maskable;
#ifdef TWO_RECV
  char buf2[80];
  mx_segment_t seg2[2];
  mx_request_t handle2;
#endif
  uint32_t result;

  sender = 0;	/* by default, we are not the sender */
  remote_hostname = NULL;

  unmaskable = 0x12345678;
  maskable = 0xabcd1234;

  while ((c = getopt(argc, argv, "h:e:")) != EOF) switch(c) {
  case 'e':
    remote_endpoint_id = atoi(optarg);
    sender = 1;
    break;
  case 'h':
    remote_hostname = optarg;
    sender = 1;
    break;
  default:
    fprintf(stderr, "Usage: hello [-h <hostname> [-e endpoint_id] ]\n");
    exit(1);
    break;
  }

  if (sender && (remote_hostname == NULL)) {
    fprintf(stderr, "If remote endpoint ID is specified, hostname must be also\n");
    exit(1);
  }

  rc = mx_init();
  if (rc != MX_SUCCESS) {
    fprintf(stderr, "mx_init: %s\n", mx_strerror(rc));
    exit(1);
  }

  rc = mx_open_endpoint(MX_ANY_NIC, MX_ANY_ENDPOINT, 
      HELLO_FILTER, NULL, 0, &my_endpoint);
  if (rc != MX_SUCCESS) {
    fprintf(stderr, "mx_open_endpoint: %s\n", mx_strerror(rc));
    exit(1);
  }

  rc = mx_get_endpoint_addr(my_endpoint, &my_address);
  if (rc != MX_SUCCESS) {
    fprintf(stderr, "mx_get_endpoint_addr: %s\n", mx_strerror(rc));
    exit(1);
  }

  rc = mx_decompose_endpoint_addr(my_address,
      &my_nic_id, &my_endpoint_id);
  if (rc != MX_SUCCESS) {
    fprintf(stderr, "mx_decompose_endpoint_addr: %s\n", mx_strerror(rc));
    exit(1);
  }
  printf("my_nic_id = 0x%08x%08x\n",MX_U32(my_nic_id), MX_L32(my_nic_id)); 
  printf("my_endpoint_id = %d\n", my_endpoint_id);

  if (sender) {
    rc = mx_hostname_to_nic_id(remote_hostname, &remote_nic_id);
    if (rc != MX_SUCCESS) {
      fprintf(stderr, "Cannot find host '%s': %s\n", remote_hostname,
	  mx_strerror(rc));
      mx_finalize();
      exit(1);
    }

    printf("dest = %x%08x:%x:%x\n",
	MX_U32(remote_nic_id), MX_L32(remote_nic_id),
	remote_endpoint_id, HELLO_FILTER);

    /* Create remote endpoint address */
    rc = mx_connect(my_endpoint, remote_nic_id,
	remote_endpoint_id, HELLO_FILTER, MX_INFINITE, &dest);
    if (rc != MX_SUCCESS) {
      fprintf(stderr, "mx_compose_endpoint(): %s\n",
	  mx_strerror(rc));
      mx_finalize();
      exit(1);
    }

    seg[0].segment_ptr = "Hello";
    seg[0].segment_length = strlen(seg[0].segment_ptr);
    seg[1].segment_ptr = ", world.\n";
    seg[1].segment_length = strlen(seg[1].segment_ptr) + 1;

    rc = mx_isend(my_endpoint, seg, 2, dest, MAKE_MATCH(unmaskable, maskable), NULL, &handle);

    if (rc != MX_SUCCESS) {
      fprintf(stderr, "mx_isend: %s\n", mx_strerror(rc));
      mx_finalize();
      exit(1);
    }

  } else {

    /* If receiver, print endpoing so sender has a chance of finding us! */
    printf("Receiver endpoint ID is %d\n", my_endpoint_id);

    /* wait for a bit to test unexpected receive path
    (void) mx_wait_all(my_endpoint, 10*1000, &handle, &stat);
    */

    seg[0].segment_ptr = buf;
    seg[0].segment_length = 1;
    seg[1].segment_ptr = buf + 1;
    seg[1].segment_length = sizeof (buf) - 1;

    rc = mx_irecv(my_endpoint, seg, 2, MAKE_MATCH(unmaskable, maskable), MX_MATCH_MASK_NONE,
	NULL, &handle);
    if (rc != MX_SUCCESS) {
      fprintf(stderr, "mx_irecv: %s\n", mx_strerror(rc));
      mx_finalize();
      exit(1);
    }

#ifdef TWO_RECV 
    seg2[0].segment_ptr = buf2;
    seg2[0].segment_length = 1;
    seg2[1].segment_ptr = buf2 + 1;
    seg2[1].segment_length = sizeof (buf2) - 1;
    rc = mx_irecv(my_endpoint, seg2, 2, MAKE_MATCH(unmaskable, maskable), match_mask, NULL, NULL, &handle2);
    if (rc != MX_SUCCESS) {
      fprintf(stderr, "mx_irecv: %s\n", mx_strerror(rc));
      mx_finalize();
      exit(1);
    }
#endif

  }

  if (sender) {

    /* wait for operation to complete */
    rc = mx_wait(my_endpoint, &handle, 30*1000, &stat, &result);
    if (rc != MX_SUCCESS ||
	!result) {
      fprintf(stderr, "mx_wait: %s\n", mx_strerror(rc));
      mx_finalize();
      exit(1);
    }
    printf("mx_wait, handle = %p, return = %s\n", handle, mx_strerror(rc));
    
  }
  else {
    
    /* wait for operation to complete */
    rc = mx_wait(my_endpoint, &handle, 30*1000, &stat, &result);
    if (rc != MX_SUCCESS ||
	!result) {
      fprintf(stderr, "mx_wait: %s\n", mx_strerror(rc));
      mx_finalize();
      exit(1);
    }
printf("mx_wait, handle = %p, return = %s\n", handle, mx_strerror(rc));
printf("status code=%d, len=%d\n",
  stat.code, stat.msg_length);

   printf(buf);

#ifdef TWO_RECV 
   /* wait for operation to complete */
   rc = mx_wait(my_endpoint, handle2, 30*1000, &stat);
   if (rc != MX_SUCCESS) {
     fprintf(stderr, "mx_wait: %s\n", mx_strerror(rc));
     mx_finalize();
     exit(1);
   }
printf("mx_wait, handle = %p, return = %s\n", handle, mx_strerror(rc));

    printf(buf2);
#endif

  }

  mx_close_endpoint(my_endpoint);
  mx_finalize();
  return 0;
}
